#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "mdPhone.h"
#define DATAPATH "C:\\Program Files\\Melissa DATA\\DQT\\Data"

mdPhone hPhoneLib;

int main(int argc,char *argv[])
{
  char phone[20],zip[10], *p;
  char *results;
  char latitude[20], longitude[20];
  float distance, bearing;
  double lat, lng;

  hPhoneLib = mdPhoneCreate();

    /********************** LICENSE STRINGS *************************
    *     To unlock the full functionality of Phone Object,         *
    * please call a sales representative at 1-800-MELISSA ext. 3    *
    *         (1-800-635-4772 x3) for a license string.             *
    *     Without a valid license string, the demo will process     *
    *                only code Nevada Zip Codes.                    *
    *                 REPLACE "DEMO" with LICENSE STRING            *         
    *                                                               *
    *   SetLicenseString will also check for a valid license in the *
    *   MDPHONE_LICENSE(Environment) variable. This allows you to   *
    *   modify the license without recompiling the project          *
    ****************************************************************/

  mdPhoneSetLicenseString(hPhoneLib , "DEMO");
  printf(" Build Number: %s \n", mdPhoneGetBuildNumber(hPhoneLib));

    /********************** DATA FILE PATHS **********************
    *    This sample sets the data file path to the installation *
    * default.  If you installed your Melissa Data data files to *
    * a different path, enter that location it below.            *
    * The Data Files Directory must contain the following files: *
    * mdAddr.dat, mdPhone.dat, mdPhone.idx and ZIPNPA.TXT.       *
    *************************************************************/


  if(mdPhoneInitialize(hPhoneLib,DATAPATH) != 0)
  {
    printf("Build : %s \n", mdPhoneGetInitializeErrorString(hPhoneLib));
    return 0;
  }

  printf("Database Date: %s \n", mdPhoneGetDatabaseDate(hPhoneLib));
  printf("\n");
    
     /***************************************************************
     *  Remember, without a valid license, you can only process     *
     *  Nevada numbers - for example:                               *
     *      PhoneNumber: 702-896-5154                               *
     *          ZipCode: 89119                                      *
     ***************************************************************/

  printf("Enter Telephone: ");
  fgets(phone, sizeof phone, stdin);
  if((p = strchr(phone, '\n')) != NULL) 
    *p = '\0';

  printf("      Enter Zip: ");
  fgets(zip, sizeof zip, stdin);
  if((p = strchr(zip, '\n')) != NULL) 
    *p = '\0';

  mdPhoneLookup(hPhoneLib,phone,zip);
  //mdPhoneCorrectAreaCode(hPhoneLib,phone,zip);
  results = mdPhoneGetResults(hPhoneLib);
    if ((strstr(results,"PS01")!=0) || (strstr(results,"PS02")!=0))
  {
    printf("\n\n====================\nLookup Results\n====================\n");
    
    if (strstr(results,"PS01")!=0)
              printf("Phone validated to 10 digits\n");
    else if (strstr(results,"PS02")!=0)
              printf("Phone validated to 7 digits\n");
    printf("Area Code: %s \n", mdPhoneGetAreaCode(hPhoneLib));
    printf("   Prefix: %s \n", mdPhoneGetPrefix(hPhoneLib));
    printf("   Suffix: %s \n", mdPhoneGetSuffix(hPhoneLib));
     
    if (strstr(results,"PS07")!=0)
               printf("Exchange Type: Cellular\n");
        if (strstr(results,"PS08")!=0)
               printf("Exchange Type: Land Line\n");
        else if (strstr(results,"PS09")!=0)
               printf("Exchange Type: Voip\n");

    if (strstr(results,"PS10")!=0)
               printf("Phone Type: Residential\n");
        if (strstr(results,"PS11")!=0)
               printf("Phone Type: Business\n");
        if (strstr(results,"PS12")!=0)
               printf("Phone Type: Small/Home Office\n");
    
    printf("\n");
    printf("\n\n===========================\n");
    printf("  Wire Center Geographic Data\n");
    printf("\n\n===========================\n");
    printf("        City: %s \n", mdPhoneGetCity(hPhoneLib));
    printf("       State: %s \n", mdPhoneGetState(hPhoneLib));
    printf(" County FIPS: %s \n", mdPhoneGetCountyFips(hPhoneLib));
    printf(" County Name: %s \n", mdPhoneGetCountyName(hPhoneLib));
    printf("   Time Zone: %s \n", mdPhoneGetTimeZone(hPhoneLib));
    printf("TimeZoneCode: %s \n", mdPhoneGetTimeZoneCode(hPhoneLib));
    printf("Country Code: %s \n", mdPhoneGetCountryCode(hPhoneLib));
    printf("\n");
    printf(" Latitude: %s \n", mdPhoneGetLatitude(hPhoneLib));
    printf("Longitude: %s \n", mdPhoneGetLongitude(hPhoneLib));
    printf("\n\n");

    printf("==============================================\n");
    printf("        Distance and Bearing Example\n");
    printf(" Lat / Long of US Capital: 38.889722  -77.0075 \n");
    printf("==============================================\n");
    memcpy(latitude,mdPhoneGetLatitude(hPhoneLib),20);
    memcpy(longitude,mdPhoneGetLongitude(hPhoneLib),20);
    lat = atof(latitude);
    lng = atof(longitude);
    distance = mdPhoneComputeDistance(hPhoneLib, atof(latitude), atof(longitude), 38.889722, -77.0075);
    bearing = mdPhoneComputeBearing(hPhoneLib, atof(latitude), atof(longitude), 38.889722, -77.0075);
    printf(" Distance: %.2f miles\n", distance);
    printf("  Bearing: %.2f degrees\n", bearing);
    printf("\n\n");
      
    mdPhoneCorrectAreaCode(hPhoneLib,phone,zip);
    results = mdPhoneGetResults(hPhoneLib);
        if (strstr(results,"PS03")!=0)
    {
      printf("===============================\n");
      printf("  Corrected Area Code Results\n");
      printf("===============================\n");
      printf("    Area Code: %s \n", mdPhoneGetAreaCode(hPhoneLib));
      printf("New Area Code: %s \n", mdPhoneGetNewAreaCode(hPhoneLib));
      printf("       Prefix: %s \n", mdPhoneGetPrefix(hPhoneLib));
      printf("       Suffix: %s \n", mdPhoneGetSuffix(hPhoneLib));
      printf("    Extension: %s \n", mdPhoneGetExtension(hPhoneLib));
      printf("      Results: %s \n", mdPhoneGetResults(hPhoneLib));
    }
    
    printf("\n");
  }

  mdPhoneDestroy(hPhoneLib);
}
